﻿Imports System.IO
Imports System.ComponentModel
Imports System.Windows.Threading
Imports System.Xml.Serialization

Public Class StudentBodyPresenter
    Implements INotifyPropertyChanged
    Public Event PropertyChanged As PropertyChangedEventHandler Implements System.ComponentModel.INotifyPropertyChanged.PropertyChanged

    Private _studentBody As StudentBody
    Private rand As New Random()

    Public Sub New()
        Dim uri As New Uri("http://www.charlespetzold.com/Students/students.xml") ' , UriKind.Relative)
        Dim webClient As New WebClient()
        AddHandler webClient.DownloadStringCompleted, AddressOf OnDownloadStringCompleted
        webClient.DownloadStringAsync(uri)
    End Sub


    Private Sub OnDownloadStringCompleted(ByVal sender As Object,
                                          ByVal args As DownloadStringCompletedEventArgs)
        Dim reader As New StringReader(args.Result)
        Dim xml As New XmlSerializer(GetType(StudentBody))
        StudentBody = TryCast(xml.Deserialize(reader), StudentBody)
        Dim tmr As New DispatcherTimer()
        AddHandler tmr.Tick, AddressOf TimerOnTick
        tmr.Interval = TimeSpan.FromMilliseconds(100)
        tmr.Start()
    End Sub


    Public Property StudentBody() As StudentBody
        Protected Set(ByVal value As StudentBody)
            If _studentBody IsNot value Then
                _studentBody = value
                OnPropertyChanged("StudentBody")
            End If
        End Set
        Get
            Return _studentBody
        End Get
    End Property


    Protected Overridable Sub OnPropertyChanged(ByVal propChanged As String)
        RaiseEvent PropertyChanged(Me, New PropertyChangedEventArgs(propChanged))
    End Sub


    Private Sub TimerOnTick(ByVal sender As Object, ByVal args As EventArgs)
        Dim index = rand.Next(_studentBody.Students.Count)
        Dim student = _studentBody.Students(index)

        Dim factor = 1 + (rand.NextDouble() - 0.5) / 5

        student.GradePointAverage =
            Math.Max(0, Math.Min(5, Decimal.Round(CDec(factor) * student.GradePointAverage, 2)))
    End Sub
End Class